#include "MDR32F9Qx_config.h"
#include "MDR32F9Qx_interrupt.h"

#define ASSERT_INFO_FILE_ID FILEID__MDR32F9X_INTERRUPT_C

#if defined (USE_MDR1986VE9x) || defined (USE_MDR1986VE3)
#define NUM_INTERRUPTS  48
#elif defined (USE_MDR1986BE4)
#define NUM_INTERRUPTS  39
#endif

#define INTERRUPT(irq)  ((int32_t)irq + 16)

#if defined (__ICCARM__)
#pragma data_alignment=1024
static __no_init void (*pfnRAMVectors[NUM_INTERRUPTS])(void) @ "VTABLE";
#elif
#error "Need a realisation for your compiler"
#endif

/*
 * This is the default interrupt handler for all interrupts. It simply loops
 * forever so that the system state is preserved for observation by a
 * debugger. Since interrupts should be disabled before unregistering the
 * corresponding handler, this should never be called.
 */
static void IntDefaultHandler(void)
{
  while (1)
  {
    // Capture
  }
}

void IntRegister(IRQn_Type IRQn, void (*pfnHandler)(void))
{
  /*
   * Check the arguments.
   */
  assert_param(INTERRUPT(IRQn) < NUM_INTERRUPTS);

  /*
   * Make sure that the RAM vector table is correctly aligned.
   */
  assert_param(((uint32_t)pfnRAMVectors & 0x03ff) == 0);

  /*
   * See if the RAM vector table has been initialized.
   */
  if (SCB->VTOR != (uint32_t)pfnRAMVectors)
  {
    uint32_t *src = (uint32_t *)SCB->VTOR;
    uint32_t *dst = (uint32_t *)pfnRAMVectors;
    uint32_t n = NUM_INTERRUPTS;

    /*
     * Copy the vector table from the beginning of FLASH
     * to the RAM vector table.
     */
    while (n--)
      *dst++ = *src++;

    /*
     * Point the NVIC at the RAM vector table.
     */
    SCB->VTOR = (uint32_t)pfnRAMVectors;
  }

  /*
   * Save the interrupt handler.
   */
  pfnRAMVectors[INTERRUPT(IRQn)] = pfnHandler;
}

void IntUnregister(IRQn_Type IRQn)
{
  /*
   * Check the arguments.
   */
  assert_param(INTERRUPT(IRQn) < NUM_INTERRUPTS);

  /*
   * Reset the interrupt handler.
   */
  pfnRAMVectors[INTERRUPT(IRQn)] = IntDefaultHandler;
}
