/**
  ******************************************************************************
  * @file    main.c
  *
  * @brief   На выводе E[8] устанавливается 1 и запускается сторожевой таймер.
  *          При достижении таймером нуля в первый раз таймер будет
  *          перезапущен и установится флаг прерывания таймера. А так как
  *          обрабочик прерывания не разрешен - флаг не будет обработан, и после
  *          второго достижения нуля микроконтроллер будет полностью
  *          перезагружен (вывод E[8] при этом будет переведен в третье
  *          состояние).
  *
  *          Компилятор: GCC ARM 4.9.3
  *          Среда: Qt Creator 3.4.2
  *
  * @author  НИИЭТ
  *             - Богдан Колбов (bkolbov), kolbov@niiet.ru
  * @date    15.01.2016
  *
  ******************************************************************************
  * @attention
  *
  * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ КАКИХ-ЛИБО
  * ГАРАНТИЙ, ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ ГАРАНТИИ ТОВАРНОЙ
  * ПРИГОДНОСТИ, СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И ОТСУТСТВИЯ
  * НАРУШЕНИЙ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ. ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ
  * ПРЕДНАЗНАЧЕНО ДЛЯ ОЗНАКОМИТЕЛЬНЫХ ЦЕЛЕЙ И НАПРАВЛЕНО ТОЛЬКО НА
  * ПРЕДОСТАВЛЕНИЕ ДОПОЛНИТЕЛЬНОЙ ИНФОРМАЦИИ О ПРОДУКТЕ, С ЦЕЛЬЮ СОХРАНИТЬ ВРЕМЯ
  * ПОТРЕБИТЕЛЮ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ
  * ОТВЕТСТВЕННОСТИ ПО КАКИМ-ЛИБО ИСКАМ, ЗА ПРЯМОЙ ИЛИ КОСВЕННЫЙ УЩЕРБ, ИЛИ
  * ПО ИНЫМ ТРЕБОВАНИЯМ, ВОЗНИКШИМ ИЗ-ЗА ИСПОЛЬЗОВАНИЯ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
  * ИЛИ ИНЫХ ДЕЙСТВИЙ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
  *
  * <h2><center>&copy; 2016 ОАО "НИИЭТ"</center></h2>
  ******************************************************************************
  */

#include "niietcm4.h"

#define DELAY_VALUE 1000000

void SystemInit()
{
    volatile uint32_t delay = DELAY_VALUE;

    while(delay)
    {
        delay--;
    }

    // настройка E[8] на выход
    GPIO_Init_TypeDef GPIO_InitStruct;
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Dir = GPIO_Dir_Out;
    GPIO_InitStruct.GPIO_Out = GPIO_Out_En;
    GPIO_InitStruct.GPIO_Pin = GPIO_Pin_8;
    GPIO_Init(NT_GPIOE, &GPIO_InitStruct);

    //устанавливаем 1 и немного ждем, чтобы моргание светодиода было различимо глазу
    GPIO_SetBits(NT_GPIOE, GPIO_Pin_8);
    delay = DELAY_VALUE;
    while(delay)
    {
        delay--;
    }

    //инициализируем сторожевой таймер
    RCC_PeriphClkCmd(RCC_PeriphClk_WD, ENABLE);
    RCC_PeriphRstCmd(RCC_PeriphRst_WD, ENABLE);

    WATCHDOG_SetReload(0xC0DE);
    WATCHDOG_RstCmd(ENABLE);
    WATCHDOG_Cmd(ENABLE);
}

int main()
{
    while(1);
}
