/**
  ******************************************************************************
  * @file    niietcm4_conf.h
  *
  * @brief   Файл конфигурации драйвера.
  *
  *          Основные функции:
  *           - Исключение исходного кода для неиспользуемой периферии.
  *           - Включение assert'ов.
  *
  * @author  НИИЭТ
  *             - Богдан Колбов (bkolbov), kolbov@niiet.ru
  * @date    26.10.2015
  *
  ******************************************************************************
  * @attention
  *
  * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ КАКИХ-ЛИБО
  * ГАРАНТИЙ, ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ ГАРАНТИИ ТОВАРНОЙ
  * ПРИГОДНОСТИ, СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И ОТСУТСТВИЯ
  * НАРУШЕНИЙ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ. ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ
  * ПРЕДНАЗНАЧЕНО ДЛЯ ОЗНАКОМИТЕЛЬНЫХ ЦЕЛЕЙ И НАПРАВЛЕНО ТОЛЬКО НА
  * ПРЕДОСТАВЛЕНИЕ ДОПОЛНИТЕЛЬНОЙ ИНФОРМАЦИИ О ПРОДУКТЕ, С ЦЕЛЬЮ СОХРАНИТЬ ВРЕМЯ
  * ПОТРЕБИТЕЛЮ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ
  * ОТВЕТСТВЕННОСТИ ПО КАКИМ-ЛИБО ИСКАМ, ЗА ПРЯМОЙ ИЛИ КОСВЕННЫЙ УЩЕРБ, ИЛИ
  * ПО ИНЫМ ТРЕБОВАНИЯМ, ВОЗНИКШИМ ИЗ-ЗА ИСПОЛЬЗОВАНИЯ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
  * ИЛИ ИНЫХ ДЕЙСТВИЙ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
  *
  * <h2><center>&copy; 2015 ОАО "НИИЭТ"</center></h2>
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __NIIETCM4_CONF_H
#define __NIIETCM4_CONF_H

/* Includes ------------------------------------------------------------------*/
/* Раскомментируйте/закоментируйте, чтобы включить/отключить заголовочный файл периферии */
#include "niietcm4_gpio.h"
#include "niietcm4_rcc.h"
#include "niietcm4_dma.h"
#include "niietcm4_uart.h"
#include "niietcm4_timer.h"
#include "niietcm4_rtc.h"
#include "niietcm4_bootflash.h"
#include "niietcm4_userflash.h"
#include "niietcm4_extmem.h"
#include "niietcm4_adc.h"
#include "niietcm4_watchdog.h"
#include "niietcm4_cap.h"
#include "niietcm4_pwm.h"
#include "niietcm4_irq.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Раскомментируйте строку ниже для включения макроса "assert_param" в коде драйвера */
/* #define USE_FULL_ASSERT    1 */

/* Exported macro ------------------------------------------------------------*/
#ifdef  USE_FULL_ASSERT

/**
  * @brief  Данный макрос используется для проверки параметров, передаваемых функции.
  * @param  expr Если равен FALSE, то вызывается функция assert_failed, которая
  *         показывает имя файла и номер строки, где произошел вызов. Если равен TRUE,
  *         то возвращаемое значение отсутсвует.
  * @retval Нет
  */
  #define assert_param(expr) ((expr) ? (void)0 : assert_failed((uint8_t *)__FILE__, __LINE__))
/* Exported functions ------------------------------------------------------- */
  void assert_failed(uint8_t* file, uint32_t line);
#else
  #define assert_param(expr) ((void)0)
#endif /* USE_FULL_ASSERT */

#endif /* __NIIETCM4_CONF_H */

/******************* (C) COPYRIGHT 2015 NIIET *****END OF FILE****/
