import qbs
import qbs.FileInfo

Product {
    type: ["application", "hex", "bin", "size" ]
    Depends { name:"cpp" }

    property string vendor: "NIIET"
    property string target: "K1921VK01T"
    property string lib_path: "../../../../Libs/"
    property string periph_driver_path: lib_path + "Periph_Driver/"
    property string cmsis_path: lib_path + "CMSIS/"
    property string device_path: lib_path + "Device/" + vendor +"/"
    property string ldscripts_path: "../ldscripts/"

    cpp.debugInformation: true
    cpp.defines: [
        "__STARTUP_CLEAR_BSS",
        "__NO_SYSTEM_INIT",
        "__START=main",
        target
    ]
    cpp.optimization: "small"
    cpp.cxxFlags: [
        "-std=c++11"
    ]
    cpp.cFlags: [
        "-std=gnu99"
    ]
    cpp.warningLevel: "all"
    cpp.commonCompilerFlags: [
        "-mthumb",
        "-mcpu=cortex-m4",
        "-mfloat-abi=hard",
        "-mfpu=fpv4-sp-d16",
        "-fdata-sections",
        "-ffunction-sections",
        "-flto"
    ]

    cpp.positionIndependentCode: false
    cpp.executableSuffix: ".elf"
    cpp.linkerScripts: [
        ldscripts_path + target + ".ld",
    ]
    cpp.linkerFlags:[
        "-mthumb",
        "-mcpu=cortex-m4",
        "-mfloat-abi=hard",
        "-mfpu=fpv4-sp-d16",
        "--specs=nano.specs",
        "-Wl,--gc-sections",
        "-lnosys","-lgcc","-lc",
    ]

    cpp.includePaths: [
        cmsis_path + "Include/",
        device_path + target + "/Include/",
        periph_driver_path + "/Include/"
    ]

    Group {
        name: "Application"
        prefix: "./"
        files: [
            "*.c",
            "*.cpp",
            "*.h",
            "*.s"
        ]
    }
    
    Group {
        name: "CMSIS"
        prefix: cmsis_path + "/**/"
        files: [
            "*.c",
            "*.cpp",
            "*.h",
            "*.s"
        ]
    }

    Group {
        name: "Peripheral Driver"
        prefix: periph_driver_path + "/**/"
        files: [
            "*.c",
            "*.cpp",
            "*.h",
            "*.s"
        ]
    }

    Group {
        name: "Device"
        prefix: device_path + target + "/**/"
        files: [
            "*.c",
            "*.cpp",
            "*.h",
            "*.s"
        ]
    }
    Group {
        name: "Linker Scripts"
        prefix: ldscripts_path + "/**/"
        files: "*.ld"
    }

    Rule {
        id: hex
        inputs: "application"
        Artifact {
            fileTags: ["hex"]
            filePath: FileInfo.baseName(input.filePath) + ".hex"
        }
        prepare: {
            var args = ["-O", "ihex", input.filePath, output.filePath];
            var cmd = new Command("arm-none-eabi-objcopy", args);
            cmd.description = "converting to hex: "+FileInfo.fileName(input.filePath);
            cmd.highlight = "linker";
            return cmd;

        }
    }

    Rule {
        id: bin
        inputs: "application"
        Artifact {
            fileTags: ["bin"]
            filePath: FileInfo.baseName(input.filePath) + ".bin"
        }
        prepare: {
            var args = ["-O", "binary", input.filePath, output.filePath];
            var cmd = new Command("arm-none-eabi-objcopy", args);
            cmd.description = "converting to bin: "+FileInfo.fileName(input.filePath);
            cmd.highlight = "linker";
            return cmd;

        }
    }

    Rule {
        id: size
        inputs: ["application"]
        Artifact {
            fileTags: ["size"]
            filePath: "-"
        }
        prepare: {
            var args = [input.filePath];
            var cmd = new Command("arm-none-eabi-size", args);
            cmd.description = "File size: " + FileInfo.fileName(input.filePath);
            cmd.highlight = "linker";
            return cmd;
        }
    }
}


