/**
  ******************************************************************************
  * @file    retarget.h
  *
  * @brief   Содержит прототип функции инициализации UART для использования
  *          в качестве аппаратного интерфейса для printf.
  *
  *          UART0 использует:
  *             - C[3] (TX)
  *             - C[4] (RX)
  *          UART1 использует:
  *             - A[3] (TX)
  *             - A[4] (RX)
  *          UART2 использует:
  *             - F[10] (TX)
  *             - F[11] (RX)
  *          UART3 использует:
  *             - D[2] (TX)
  *             - D[1] (RX)
  *
  *          Компилятор: GCC ARM 4.9.3
  *
  * @author  НИИЭТ
  *             - Богдан Колбов (bkolbov), kolbov@niiet.ru
  * @date    02.12.2015
  *
  ******************************************************************************
  * @attention
  *
  * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ КАКИХ-ЛИБО
  * ГАРАНТИЙ, ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ ГАРАНТИИ ТОВАРНОЙ
  * ПРИГОДНОСТИ, СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И ОТСУТСТВИЯ
  * НАРУШЕНИЙ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ. ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ
  * ПРЕДНАЗНАЧЕНО ДЛЯ ОЗНАКОМИТЕЛЬНЫХ ЦЕЛЕЙ И НАПРАВЛЕНО ТОЛЬКО НА
  * ПРЕДОСТАВЛЕНИЕ ДОПОЛНИТЕЛЬНОЙ ИНФОРМАЦИИ О ПРОДУКТЕ, С ЦЕЛЬЮ СОХРАНИТЬ ВРЕМЯ
  * ПОТРЕБИТЕЛЮ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ
  * ОТВЕТСТВЕННОСТИ ПО КАКИМ-ЛИБО ИСКАМ, ЗА ПРЯМОЙ ИЛИ КОСВЕННЫЙ УЩЕРБ, ИЛИ
  * ПО ИНЫМ ТРЕБОВАНИЯМ, ВОЗНИКШИМ ИЗ-ЗА ИСПОЛЬЗОВАНИЯ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
  * ИЛИ ИНЫХ ДЕЙСТВИЙ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
  *
  * <h2><center>&copy; 2015 ОАО "НИИЭТ"</center></h2>
  ******************************************************************************
  */

#include "niietcm4.h"
#include <stdio.h>

// выбор UART для вывода printf
#ifndef RETARGET_UART
    #define RETARGET_UART           NT_UART2
#endif

// текущая системная частота в Гц
#ifndef RETARGET_CLK_VAL
    #define RETARGET_CLK_VAL        EXT_OSC_VALUE
#endif

// желаемая скорость передачи
#ifndef RETARGET_BAUDRATE_VAL
    #define RETARGET_BAUDRATE_VAL   115200
#endif

// функция инициализации необходимого UART - настраивает сброс, тактирование,
// порты ввода-вывода и непосредственно сам блок UART
void retarget_init();
