/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __USB_CDC_VCP_H
#define __USB_CDC_VCP_H

#include "stdint.h"

#define SEND_ENCAPSULATED_COMMAND               0x00
#define GET_ENCAPSULATED_RESPONSE               0x01
#define SET_COMM_FEATURE                        0x02
#define GET_COMM_FEATURE                        0x03
#define CLEAR_COMM_FEATURE                      0x04
#define SET_LINE_CODING                         0x20
#define GET_LINE_CODING                         0x21
#define SET_CONTROL_LINE_STATE                  0x22
#define SEND_BREAK                              0x23
#define NO_CMD                                  0xFF

uint32_t VCP_PutChar(uint8_t byte);
uint8_t VCP_GetChar(void);
uint32_t VCP_IsRxBufEmpty(void);
uint32_t VCP_IsTxBufFull(void);

#endif /* __USB_CDC_VCP_H */
