/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __USB_CONST_H
#define __USB_CONST_H

#include "usb_dev.h"

#define USB_AUDIO_CLASS                             0x1
#define USB_CDC_CONTROL_CLASS                       0x2
#define USB_HID_CLASS                               0x3
#define USB_PHYSICAL_CLASS                          0x5
#define USB_IMAGE_CLASS                             0x6
#define USB_PRINTER_CLASS                           0x7
#define USB_MASS_STORAGE_CLASS                      0x8
#define USB_HUB_STORAGE_CLASS                       0x9
#define USB_CDC_DATA_CLASS                          0xa
#define USB_SMART_CARD_CLASS                        0xb
#define USB_CONTENT_SECURITY_CLASS                  0xd
#define USB_DIAGNOSTIC_DEVICE_CLASS                 0xdc
#define USB_WIRELESS_CONTROLLER_CLASS               0xe0
#define USB_APPLICATION_SPECIFIC_CLASS              0xfe
#define USB_VENDOR_SPECIFIC_CLASS                   0xff

#define USB_CONTROL_TRANSFER_TYPE                   0x0
#define USB_ISOC_TRANSFER_TYPE                      0x1
#define USB_BULK_TRANSFER_TYPE                      0x2
#define USB_INTERRUPT_TRANSFER_TYPE                 0x3

#define USB_GET_STATUS_REQUEST                      0
#define USB_CLEAR_FEATURE_REQUEST                   1
#define USB_SET_FEATURE_REQUEST                     3
#define USB_SET_ADDRESS_REQUEST                     5
#define USB_GET_DESCRIPTOR_REQUEST                  6
#define USB_SET_DESCRIPTOR_REQUEST                  7
#define USB_GET_CONFIGURATION_REQUEST               8
#define USB_SET_CONFIGURATION_REQUEST               9
#define USB_GET_INTERFACE_REQUEST                   10
#define USB_SET_INTERFACE_REQUEST                   11
#define USB_SYNCH_FRAME_REQUEST                     12

#define USB_DEV_DESCRIPTOR_TYPE                     1
#define USB_CONFIG_DESCRIPTOR_TYPE                  2
#define USB_STRING_DESCRIPTOR_TYPE                  3
#define USB_INTERFACE_DESCRIPTOR_TYPE               4
#define USB_ENDPOINT_DESCRIPTOR_TYPE                5
#define USB_OTG_DESCRIPTOR_TYPE                     9

#define USB_DEVICE_DESCRIPTOR_TYPE_MASK             0x0100
#define USB_CONFIG_DESCRIPTOR_TYPE_MASK             0x0200
#define USB_STRING_DESCRIPTOR_TYPE_MASK             0x0300
#define USB_INTERFACE_DESCRIPTOR_TYPE_MASK          0x0400
#define USB_ENDPOINT_DESCRIPTOR_TYPE_MASK           0x0500
#define USB_OTG_DESCRIPTOR_TYPE_MASK                0x0900

typedef enum
{
  USB_DEV_SPEED_UNKNOWN = 0,
  USB_DEV_SPEED_FULL,
  USB_DEV_SPEED_LOW,
  USB_DEV_SPEED_HIGH
} USB_DEV_SPEED_VAL;

/*#define USB_DEV_SPEED_UNKNOWN 0
#define USB_DEV_SPEED_FULL 1
#define USB_DEV_SPEED_LOW 2
#define USB_DEV_SPEED_HIGH 3*/


#ifndef SUCCESS
#define SUCCESS 1
#endif

#ifndef ERROR
#define ERROR !(SUCCESS)
#endif

__packed typedef struct USB_DEVICE_REQUEST
{
    uint8_t   bmRequestType;
    uint8_t   bRequest;
    uint16_t  wValue;
    uint16_t  wIndex;
    uint16_t  wLength;
} USB_DEVICE_REQUEST;

/*__packed typedef struct USB_DEVICE
{
    uint8_t                 port;
    uint8_t                 address;
    bool                    direct_connect;
    uint8_t                 speed;
    uint8_t                 configuration;
    uint8_t                 num_endpoints;
    uint8_t                 endpoint_max_pkt[8];
    uint16_t                need_ping_ep;        //      ,    PING
    uint8_t                 enum_state;
    uint8_t                 enum_retry;
    uint8_t                 otg_attributes;      //  
    struct CLASS_DRIVER     *driver;
    DEVICE_DSCR_TYPE        dev_descr;
    CONFIGURATION_DSCR_TYPE cfg_descr;
    INTERFACE_DSCR_TYPE     inf_descr;
    uint32_t                enum_data;      
    uint8_t                 new_address;         //
} USB_DEVICE;*/

#endif /* __USB_CONST_H */
