/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __USB_DEV_H
#define __USB_DEV_H

#include "stdint.h"
#include "stdbool.h"

#define  USB_DESC_TYPE_DEVICE                              1
#define  USB_DESC_TYPE_CONFIGURATION                       2
#define  USB_DESC_TYPE_STRING                              3
#define  USB_DESC_TYPE_INTERFACE                           4
#define  USB_DESC_TYPE_ENDPOINT                            5
#define  USB_DESC_TYPE_DEVICE_QUALIFIER                    6
#define  USB_DESC_TYPE_OTHER_SPEED_CONFIGURATION           7

__packed typedef union
{
  uint16_t w;
  struct 
  {
    uint8_t msb;
    uint8_t lsb;
  }
  bw;
}
uint16_t_uint8_t;

/*
#define USBDev_ATTACHED   0x01
#define USBDev_POWERED    0x02
#define USBDev_DEFAULT    0x03
#define USBDev_ADDRESSED  0x04
#define USBDev_CONFIGURED 0x05
#define USBDev_SUSPENDED  0x06
*/

typedef enum
{
  USBDEV_ATTACHED = 1,
  USBDEV_POWERED,
  USBDEV_DEFAULT,
  USBDEV_ADDRESSED,
  USBDEV_CONFIGURED,
  USBDEV_SUSPENDED
} USBDEV_STATE;

typedef enum
{
  USBDEV_SPEED_FULL,
  USBDEV_SPEED_HIGH  
} USBDEV_SPEED;

#define LOBYTE(x)  ((unsigned char)(x & 0x00FF))
#define HIBYTE(x)  ((unsigned char)((x & 0xFF00) >>8))
#define  MIN(a, b)      (((a) < (b)) ? (a) : (b))

/*__packed typedef union _USBDev_Setup
{
  unsigned int d32[4];

  struct _SetupPkt_Struc_dev
  {
    uint8_t           bmRequestType;
    uint8_t           bRequest;
    uint16_t          Reserved0;
    uint16_t          wValue; //uint16_t_uint8_t        wValue;
    uint16_t          Reserved1;
    uint16_t          wIndex; //uint16_t_uint8_t        wIndex;
    uint16_t          Reserved2;
    uint16_t          wLength; //uint16_t_uint8_t        wLength;
    uint16_t          Reserved3;
  } b;
}
USBDev_Setup_TypeDef;*/

////////////////////////////////////////////////////////////////
__packed typedef struct
{
  uint8_t   bmRequestType;
  uint8_t   bRequest;
  uint16_t  wValue;
  uint16_t  wIndex;
  uint16_t  wLength;
  
  uint8_t   *xfer_buff;
  uint32_t  xfer_len;
  uint32_t  xfer_count;
} USBDev_Setup_TypeDef;
////////////////////////////////////////////////////////////////

__packed typedef struct 
{
  uint8_t       bLength;
  uint8_t       bDescriptorType;
  uint8_t       bmAttributes;
} OTG_DSCR_TYPE;

__packed typedef struct
{
  uint8_t bLength;
  uint8_t bDescriptorType;
  uint8_t bscUSB[2];
  uint8_t bDeviceClass;
  uint8_t bDeviceSubClass;
  uint8_t bDeviceProtocol;
  uint8_t bMaxPacketSize0;
  uint8_t idVendor[2];
  uint8_t idProduct[2];
  uint8_t bcdDevice[2];
  uint8_t iManufacturer;
  uint8_t iProduct;
  uint8_t iSerialNumber;
  uint8_t bNumConfigurations;
} DEVICE_DSCR_TYPE;

//Configuration descriptor
__packed typedef struct
{
  uint8_t bLength;
  uint8_t bDescriptorType;
  uint8_t wTotalLength[2];
  uint8_t bNumInterfaces;
  uint8_t bConfigurationValue;
  uint8_t iConfiguration;
  uint8_t bmAttibutes;
  uint8_t MaxPower;
} CONFIGURATION_DSCR_TYPE;

//Interface Descriptor
__packed typedef struct
{
  uint8_t bLength;
  uint8_t bDescriptorType;
  uint8_t bInterfaceNumber;
  uint8_t bAlternateSetting;
  uint8_t bNumEndpoints;
  uint8_t bInterfaceClass;
  uint8_t bInterfaceSubClass;
  uint8_t bInterfaceProtocol;
  uint8_t iInterface;
} INTERFACE_DSCR_TYPE;

//Endpoint Descriptor
__packed typedef struct
{
  uint8_t bLength;
  uint8_t bDescriptorType;
  uint8_t bEndpointAddress;
  uint8_t bmAttributes;
  uint16_t wMaxPacketSize;
  uint8_t bInterval;
} ENDPOINT_DSCR_TYPE;

__packed typedef struct
{
  CONFIGURATION_DSCR_TYPE conf_dscr;
  INTERFACE_DSCR_TYPE itface_dscr;
#ifdef USE_EP1
  ENDPOINT_DSCR_TYPE ep_dscr[USB_EP_NUMS];
#endif        
} CONFIG_DSCR_TYPE;

__packed typedef struct
{
  uint8_t   epnum;
  uint8_t   is_in;
  uint8_t   is_stall;
  uint8_t   type;
  uint32_t  max_packet;
  
  uint8_t   *xfer_buff;
  uint32_t  xfer_len;
  uint32_t  xfer_count;
  
  uint8_t   out_nak_active; //for out eps only
  
}USBDev_EP;

#define  USBD_IDX_LANGID_STR                            0x00
#define  USBD_IDX_MFC_STR                               0x01
#define  USBD_IDX_PRODUCT_STR                           0x02
#define  USBD_IDX_SERIAL_STR                            0x03
#define  USBD_IDX_CONFIG_STR                            0x04
#define  USBD_IDX_INTERFACE_STR                         0x05

#define USB_REQ_RECIPIENT_DEVICE 0x00
#define USB_REQ_RECIPIENT_INTERFACE 0x01
#define USB_REQ_RECIPIENT_ENDPOINT 0x02

typedef enum
{
  CEP_ACK = 0,
  CEP_NAK = 1,
  CEP_STALL = 2,
  CEP_ZEROLEN = 4
}CEP_RESPONSE;

typedef enum
{
  EP_FLUSH = 0,
  EP_CLRNAK = 0,
  EP_CLRTOGGLE = 3,
  EP_HALT = 4,
  EP_ZEROLEN = 5,
  EP_PKTEND = 6,
  EP_SETNAK = 7
}EP_RESPONSE;

#define USB_REQ_GET_STATUS        0x00
#define USB_REQ_CLEAR_FEATURE     0x01
#define USB_REQ_SET_FEATURE       0x03
#define USB_REQ_SET_ADDRESS       0x05
#define USB_REQ_GET_DESCRIPTOR    0x06
#define USB_REQ_SET_DESCRIPTOR    0x07
#define USB_REQ_GET_CONFIGURATION 0x08
#define USB_REQ_SET_CONFIGURATION 0x09
#define USB_REQ_GET_INTERFACE     0x0A
#define USB_REQ_SET_INTERFACE     0x0B
#define USB_REQ_SYNCH_FRAME       0x0C

#define USB_FEATURE_EP_HALT                                0
#define USB_FEATURE_REMOTE_WAKEUP                          1
#define USB_FEATURE_TEST_MODE                              2

#define CEP_IRQ_STAT_SETUP_TOKEN   (1<<0)
#define CEP_IRQ_STAT_SETUP_PACKET  (1<<1)
#define CEP_IRQ_STAT_OUT_TOKEN     (1<<2)
#define CEP_IRQ_STAT_IN_TOKEN      (1<<3)
#define CEP_IRQ_STAT_PING_TOKEN    (1<<4)
#define CEP_IRQ_STAT_DATA_PACK_TX  (1<<5)
#define CEP_IRQ_STAT_DATA_PACK_RX  (1<<6)
#define CEP_IRQ_STAT_NAK_SENT      (1<<7)
#define CEP_IRQ_STAT_STALL_SENT    (1<<8)
#define CEP_IRQ_STAT_USB_ERROR     (1<<9)
#define CEP_IRQ_STAT_STAT_COMP     (1<<10)
#define CEP_IRQ_STAT_BUFF_FULL     (1<<11)
#define CEP_IRQ_STAT_BUFF_EMPTY    (1<<12)

#define EP_IRQ_STAT_BUFF_FULL      (1<<0)
#define EP_IRQ_STAT_BUFF_EMPTY     (1<<1)
#define EP_IRQ_STAT_SHORT_PKT_TX   (1<<2)
#define EP_IRQ_STAT_DATA_PKT_TX    (1<<3)
#define EP_IRQ_STAT_DATA_PKT_RX    (1<<4)
#define EP_IRQ_STAT_OUT_TOKEN      (1<<5)
#define EP_IRQ_STAT_IN_TOKEN       (1<<6)
#define EP_IRQ_STAT_PING_TOKEN     (1<<7)
#define EP_IRQ_STAT_NAK_SENT       (1<<8)
#define EP_IRQ_STAT_STALL_SENT     (1<<9)
#define EP_IRQ_STAT_NYET_SENT      (1<<10)
#define EP_IRQ_STAT_ERR_SENT       (1<<11)

#define USBDMA_OP_READ_FROM_EP     (0<<4)
#define USBDMA_OP_WRITE_TO_EP      (1<<4)
#define USBDMA_OP_START            (1<<5)
#define USBDMA_OP_MASK_DONE        (1<<5)

uint32_t USBDev_Init(void);
uint32_t USBDev_DeInit(void);


uint32_t USBDev_SetManufacturer(char *Manufacturer);
uint32_t USBDev_SetProduct(char *Product);
uint32_t USBDev_SetSerial(uint32_t Serial);

uint32_t USBDev_Ep_Handler(uint32_t epnum); //   
uint32_t USBDev_SOF_Handler(void);          // SOF 
uint32_t USBDev_ResetDone(void);            //     USB
uint32_t USBDev_Resume(void);               //    Resume
uint32_t USBDev_Suspend(void);              //    Suspend
uint32_t USBDev_Disconnected(void);         //    

uint32_t USBDev_EP0Activate(void);
uint32_t USBDev_CEPSendResponse(CEP_RESPONSE resp);
uint32_t USBDev_PutNextCEPPacket(void);
uint32_t USBDev_GetNextCEPPacket(void);
uint32_t USBDev_CEPSendData(uint8_t *pbuf, uint32_t len);

uint32_t USBDev_ParseSetupPacket(USBDev_Setup_TypeDef *pUSB_SETUP_PACKET);
uint32_t USBD_Setup_Stage(void);
uint32_t USBD_StdDevReq(USBDev_Setup_TypeDef *pUSB_SETUP_PACKET);
uint32_t USBD_StdItfReq(USBDev_Setup_TypeDef *pUSB_SETUP_PACKET);
uint32_t USBD_GetDescriptorReq(USBDev_Setup_TypeDef *pUSB_SETUP_PACKET);
uint32_t USBD_SetAddressReq(void);
uint32_t USBD_SetConfigReq(void);
uint32_t USBD_SetCfg(uint8_t config_num);
uint32_t USBD_ClrCfg(uint8_t config_num);

//void set_usbdev_state(USBDEV_STATE state);
uint32_t get_string_to_unicode(char *desc, char *unicode);
uint32_t USBDev_EP_Open(uint8_t  ep_addr, uint32_t ep_mps, uint8_t  ep_type);
uint32_t USBDev_EP_Close(uint8_t ep_addr);
uint32_t USBDev_EPActivate(USBDev_EP *ep);     //for eps 1...4
uint32_t USBDev_EPDeactivate(USBDev_EP *ep);   //for eps 1...4 
uint32_t USBDev_EP_AvailCnt(uint8_t epnum);    //for eps 1...4
uint32_t USBDev_EPSetResponse(EP_RESPONSE resp, uint8_t epnum); //for eps 1...4
uint32_t USBDev_EPSendData(uint8_t *pbuf, uint32_t len, uint8_t epnum);

//uint32_t USBDev_GetCEPIntStatus(void);
//uint32_t USBDev_ClearCEPIntBit(uint32_t cep_bit);

uint32_t USBDev_GetEPIntStatus(uint8_t epnum); //for eps 0...4
uint32_t USBDev_ClearEPIntBit(uint8_t epnum, uint32_t ep_bit); //for eps 0...4
uint32_t USBDev_IsEPTypeIN(uint8_t epnum);     //for eps 0...4
uint32_t USBDev_SetAddress(uint8_t address);
uint32_t USBDev_EPIntEnable(uint8_t epnum);    //for eps 0...4
uint32_t USBDev_EPIntDisable(uint8_t epnum);   //for eps 0...4
uint32_t USBDev_SetOpSpeed(USBDEV_SPEED speed);
uint32_t USBDev_DMAOpStart(uint8_t *pbuf, uint32_t len, uint8_t epnum, uint32_t op);

USBDEV_STATE USBDev_ReadState(void);

uint32_t USBDev_WritePacket(uint8_t *src, uint32_t len, uint8_t epnum);
uint32_t USBDev_ReadPacket(uint8_t *dst, uint32_t len, uint8_t epnum);

uint32_t USBDev_EPPrepareRx(uint8_t *pbuf, uint32_t len, uint8_t epnum);

#endif /* __USB_DEV_H */
