/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __USB_DEV_DESCR_H
#define __USB_DEV_DESCR_H

#define EP_IN 0x80
#define EP_OUT 0x00

#define EP_CONTROL 0x00
#define EP_ISO 0x01
#define EP_BULK 0x02
#define EP_INTERRUPT 0x03

#define EP_NOSYNC 0x00
#define EP_ASYNC  0x01
#define EP_ADAPT  0x02 
#define EP_SYNC   0x03

#define EP_DATA     0x00
#define EP_FEEDBACK 0x01
#define EP_IMPLFBCK 0x02

#define USB_SELFPOWERED 0x40
#define USB_REMOTEWKUP  0x20

//    ----------------------------------------

// langID --
#define USB_DEVICE_LANGID_STR 0x0409
//----------

#define USB_DEVICE_MFC_STR "NIIET K1921VK01T"
#define USB_DEVICE_PRODUCT_STR "USB VCP device"
#define USB_DEVICE_SERIAL_STR "000000001S"
#define USB_DEVICE_CONFIG_STR "VCP device"
#define USB_DEVICE_INTERFACE_STR "VCP"

// USB DEVICE   ----------------------------------------

#define USB_DEVICE_DESCRIPTOR_TYPE 0x01
#define USB_BCD                    0x0200
#define USB_DEVICE_CLASS           0xFF
#define USB_DEVICE_SUBCLASS        0x00
#define USB_DEVICE_PROTOCOL        0xFF
#define USB_DEVICE_MAX_EP0_SIZE    64
#define USB_DEVICE_VENDOR_ID       0x0570
#define USB_DEVICE_PRODUCT_ID      0x5005
#define USB_BCD_DEVICE             0x0001
#define USB_DEVICE_IDX_MFC_STR     0x01
#define USB_DEVICE_IDX_PRODUCT_STR 0x02
#define USB_DEVICE_IDX_SERIAL_STR  0x03

//    ----------------------------------------

#define USB_DEVICE_CFG_VALUE       1
#define USB_DEVICE_ATTRIB          0 /*|USB_SELFPOWERED|USB_REMOTEWKUP*/
#define USB_DEVICE_MAXPOWER        100

//   0 ----------------------------------------------------

#define USB_DEVICE_ITFACE_NUM0      0
#define USB_DEVICE_ITFACE_ALTSET0   0
#define USB_DEVICE_ITFACE_CLASS0    0xff
#define USB_DEVICE_ITFACE_SUBCLASS0 0xff
#define USB_DEVICE_ITFACE_PROTOCOL0 0xff

//    ---------------------------------------

#define USB_DEVICE_DESC_TYPE_QUALIFIER    0x06
#define USB_BCD_QUALIFIER                 0x0200
#define USB_DEVICE_CLASS_QUALIFIER        USB_DEVICE_CLASS
#define USB_DEVICE_SUBCLASS_QUALIFIER     USB_DEVICE_SUBCLASS
#define USB_DEVICE_PROTOCOL_QUALIFIER     USB_DEVICE_PROTOCOL
#define USB_DEVICE_MAX_EP0_SIZE_QUALIFIER 64

#define USB_DEVICE_CFG_MAX_NUM            1
#define USB_DEVICE_CFG_MAX_NUM_QUALIFIER  1
#define USB_DEVICE_ITFACE_MAX_NUM         1

// END USB DEVICE   ----------------------------------------

#define USB_EP_NUMS 3

#if (USB_EP_NUMS > 0)
 #define USE_EP1
 #if (USB_EP_NUMS > 1)
  #define USE_EP2
  #if (USB_EP_NUMS > 2)
   #define USE_EP3
   #if (USB_EP_NUMS > 3)
    #define USE_EP4
   #endif
  #endif
 #endif
#endif

//    1
#ifdef USE_EP1
#define EP1_INOUT       EP_IN
#define EP1_ADDRESS     1
#define EP1_ATTRIB      EP_BULK
#define EP1_MAXPACKSIZE 64
#define EP1_INTERVAL    0

#define EP1_SYNCTYPE    EP_NOSYNC
#define EP1_USAGETYPE   EP_DATA
#endif

//    2
#ifdef USE_EP2
#define EP2_INOUT       EP_OUT
#define EP2_ADDRESS     2
#define EP2_ATTRIB      EP_BULK
#define EP2_MAXPACKSIZE 64
#define EP2_INTERVAL    0

#define EP2_SYNCTYPE    EP_NOSYNC
#define EP2_USAGETYPE   EP_DATA
#endif

//    3
#ifdef USE_EP3
#define EP3_INOUT       EP_IN
#define EP3_ADDRESS     3
#define EP3_ATTRIB      EP_INTERRUPT
#define EP3_MAXPACKSIZE 64
#define EP3_INTERVAL    2

#define EP3_SYNCTYPE    EP_NOSYNC
#define EP3_USAGETYPE   EP_DATA
#endif

//    4
#ifdef USE_EP4
#define EP4_INOUT       EP_OUT
#define EP4_ADDRESS     4
#define EP4_ATTRIB      EP_BULK
#define EP4_MAXPACKSIZE 64
#define EP4_INTERVAL    0

#define EP4_SYNCTYPE    EP_NOSYNC
#define EP4_USAGETYPE   EP_DATA
#endif

#endif /* __USB_DEV_DESCR_H */
