/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __USB_OTG_H
#define __USB_OTG_H

#include "stdbool.h"  
#include "usb_otg_irq.h"
#include "K1921VK01T.h"

typedef enum
{
  USB_ROLE_UNKNOWN = 0,
  USB_ROLE_DEVICE,
  USB_ROLE_HOST
} USB_ROLE;
  
#define USB_MAX_EP0_SIZE 64

void usbotg_init(void);
void usbotg_deinit(void);
void set_otg_role(USB_ROLE role);
USB_ROLE get_otg_role(void);
bool otg_is_host(void);
bool otg_is_device(void);
void otg_idle(void);
void set_port_change_status (bool status);

#endif //__USB_OTG_H
