#include "usb_otg.h"
#include "stdint.h"

USB_ROLE usb_role             = USB_ROLE_UNKNOWN;
volatile uint8_t port_changed = 0;
bool direct_connect_present   = false;

/*
 *         usb otg
 *
 */

void usbotg_init()
{

}

/*
 *       usb otg
 *
 */

void usbotg_deinit()
{
  
}

/*
 *    usb otg
 *
 */
extern bool in_enumeration;

void otg_idle(void)
{
  switch(get_otg_role())
  {
  case USB_ROLE_HOST:
    break;    
  case USB_ROLE_DEVICE:
    break;
  }
}

/*
 *    ,     
 *
 */

bool otg_is_host(void)
{
  if(NT_USBOTG->OTG_IRQ_STAT & (1<<5)) 
    return true;
  else                           
    return false;
}

/*
 *    ,     
 *
 */

bool otg_is_device(void)
{
  if(NT_USBOTG->OTG_IRQ_STAT & (1<<4))
    return true;
  else
    return false;
}

/*
 *     
 *
 */

void set_otg_role(USB_ROLE role)
{
  usb_role = role;
}

/*
 *      
 *
 */

USB_ROLE get_otg_role(void)
{
  return usb_role;
}

/*
 *      (  )
 *
 */

void set_port_change_status (bool status)
{
  port_changed = status;
}


